package org.eclipse.swt.net;


import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;

public class FlickrUtil {
	
public static String[] getPhotosInfo (Object rsp) {
	int length = getLength(rsp);
	String[] result = new String[length*3];
	for (int i = 0, j=0; i < length; i++){
		result[j++] = getTitle(rsp, i);
		result[j++] = getID(rsp, i); 
		result[j++] = getSecret(rsp, i);
	}
	return result;	
};
	
public static native int getLength(Object rsp) /*-{
	return rsp.photos.photo.length;
}-*/;
public static native String getID(Object rsp, int i) /*-{
	return rsp.photos.photo[i].id;
}-*/;

public static native String getTitle(Object rsp,  int i) /*-{
	return rsp.photos.photo[i].title;
}-*/;

public static native String getSecret(Object rsp, int i) /*-{
	return rsp.photos.photo[i].secret;
}-*/;


public static native String getPhotoURL(Object rsp, String size) /*-{
	for (var i = 0; i <  rsp.sizes.size.length; i++) {
		if (rsp.sizes.size[i].label == size) {
			return rsp.sizes.size[i].source;
		}
	}
	return null;
}-*/;

public static void setImage(final Listener listener, String url) {
	Display display = Display.getDefault();
	final Image image = new Image(display, url, 100, 74);
	Event e = new Event();
	e.data = image;
	listener.handleEvent(e);
}

}
